import sys #Wird benötigt, um auf Argumente im Terminal-Befehl zugreifen zu können.
import time #Wird benötigt, um den Prozess einige Sekunden zu pausieren, damit die Kamera aufwärmen kann.
import picamera #Wird benötigt, um auf das Raspberry Pi Camera Module V2 zugreifen zu können.
from fractions import Fraction #Wird benötigt, um mit rationalen Zahlen rechnen zu können.















#--------Einstellungen-----------------------------------------------------------------------------------------------------------------------------
Speicherpfad = "/home/pi/LambdaSpektrometer"
        # Der Speicherpfad, unter dem der Programmordner gespeichert ist.
        # Das Argument hinter dem letzten Schrägstrich ist der Name des Ordners.
#--------------------------------------------------------------------------------------------------------------------------------------------------




#Einstellungen der Kamera
def take_picture(name, shutter):
    camera = picamera.PiCamera()
    try:
        camera.vflip = True
        camera.rotation = 90
        camera.framerate = Fraction(1, 2)
        camera.shutter_speed = shutter
        camera.iso = 100
        camera.exposure_mode = 'off'
        camera.awb_mode = 'off'
        camera.awb_gains = (1, 1)
        time.sleep(3)
        camera.capture(name, resize=(1296, 972))
    finally:
        camera.close()
    return name




# Hauptfunktion
def main():
    # 1. Schieße Bild
    name = sys.argv[1] #sys.argv[1] ist das erste Argument des Terminal-Befehls.
    shutter = int(sys.argv[2]) #sys.argv.[2] ist das zweite Argument des Terminal-Befehls.
    raw_filename = name + "_Bild.jpg"
    take_picture(raw_filename,shutter)




main() #Hauptfunktion wird ausgeführt und enthält alle zuvor definierten Vorgänge.
