import tkinter as tk
from PIL import Image, ImageTk
from itertools import count
















#--------Einstellungen-----------------------------------------------------------------------------------------------------------------------------
Speicherpfad = "/home/pi/LambdaSpektrometer"
        # Der Speicherpfad, unter dem der Programmordner gespeichert ist.
        # Das Argument hinter dem letzten Schrägstrich ist der Name des Ordners.
#--------------------------------------------------------------------------------------------------------------------------------------------------
     
     
     
 
# Ein Label, das Bilder anzeigt und sie abspielt wenn sie GIFs sind. 
class ImageLabel(tk.Label):
    def load(self, im):
        if isinstance(im, str):
            im = Image.open(im)
        self.loc = 0
        self.frames = []

        try:
            for i in count(1):
                self.frames.append(ImageTk.PhotoImage(im.copy()))
                im.seek(8 * i)
        except EOFError:
            pass

        self.delay = 1000

    def next_frame(self):
        if self.frames:
            self.loc += 1
            self.loc %= len(self.frames)
            self.config(image=self.frames[self.loc])
            self.after(self.delay, self.next_frame)

root = tk.Tk()
screen_width = root.winfo_screenwidth()
screen_height = root.winfo_screenheight()
width = 1200
height = 185
x = (screen_width/2) - (width/2)
y = (screen_height/2) - (height/2)
root.geometry("%dx%d+%d+%d" % (width, height, x, y))
root.overrideredirect(1)
lbl = ImageLabel(root)
lbl.pack()
lbl.load(Speicherpfad + "/Images/loading.gif")
lbl.next_frame()

root.mainloop()